<?php
/*
Plugin Name: Woof! Plugin
Plugin URI: http://webredox.net
Description: Declares a plugin that will create Page Settins, VC addons & Custom Post Type
Version: 1.6
Author: webRedox
Author URI: http://webredox.net
License: GPLv2
*/

include plugin_dir_path( __FILE__ ).'metaboxes.php';
global $woof_options;


if( ! function_exists( 'portfolio_post_types' ) ) {
    function portfolio_post_types() {

        register_post_type(
            'portfolio',
            array(
                'labels' => array(
                    'name'          => __( 'Portfolios', 'portfolio' ),
                    'singular_name' => __( 'Portfolio', 'portfolio' ),
                    'add_new'       => __( 'Add New', 'portfolio' ),
                    'add_new_item'  => __( 'Add New Portfolio', 'portfolio' ),
                    'edit'          => __( 'Edit', 'portfolio' ),
                    'edit_item'     => __( 'Edit Portfolio', 'portfolio' ),
                    'new_item'      => __( 'New Portfolio', 'portfolio' ),
                    'view'          => __( 'View Portfolio', 'portfolio' ),
                    'view_item'     => __( 'View Portfolio', 'portfolio' ),
                    'search_items'  => __( 'Search Portfolio', 'portfolio' ),
                    'not_found'     => __( 'No Portfolio item found', 'portfolio' ),
                    'not_found_in_trash' => __( 'No portfolio item found in Trash', 'portfolio' ),
                    'parent'        => __( 'Parent Portfolio', 'portfolio' ),
                ),
                
                'description'       => __( 'Create a Portfolio.', 'portfolio' ),
                'public'            => true,
                'show_ui'           => true,
                'show_in_menu'          => true,
                'publicly_queryable'    => true,
				'capability_type' => 'post',
                'exclude_from_search'   => true,
                'menu_position'         => 6,
                'hierarchical'      => false,
                'query_var'         => true,
				'menu_icon' => 'dashicons-portfolio',
                'supports'  => array (
                    'title', //Text input field to create a post title.
                    'editor',
                    'thumbnail',
                    
                )
            )
        );
register_taxonomy('portfolio_category', 'portfolio', array('hierarchical' => true, 'label' => 'Portfolio Categories', 'singular_name' => 'Category', "rewrite" => true, "query_var" => true));

    }
}

add_action( 'init', 'portfolio_post_types' ); // register post type

register_taxonomy_for_object_type('category', 'custom-type');

if( ! function_exists( 'services_post_types' ) ) {
    function services_post_types() {

        register_post_type(
            'services',
            array(
                'labels' => array(
                    'name'          => __( 'Services', 'services' ),
                    'singular_name' => __( 'Services', 'services' ),
                    'add_new'       => __( 'Add New', 'services' ),
                    'add_new_item'  => __( 'Add New Services', 'services' ),
                    'edit'          => __( 'Edit', 'services' ),
                    'edit_item'     => __( 'Edit Services', 'services' ),
                    'new_item'      => __( 'New Services', 'services' ),
                    'view'          => __( 'View Services', 'services' ),
                    'view_item'     => __( 'View Services', 'services' ),
                    'search_items'  => __( 'Search Services', 'services' ),
                    'not_found'     => __( 'No Services Item found', 'services' ),
                    'not_found_in_trash' => __( 'No Services item found in Trash', 'services' ),
                    'parent'        => __( 'Parent Services', 'services' ),
                ),
                
                'description'       => __( 'Create a Services.', 'services' ),
                'public'            => true,
                'show_ui'           => true,
                'show_in_menu'          => true,
                'publicly_queryable'    => true,
				'capability_type' => 'post',
                'exclude_from_search'   => true,
                'menu_position'         => 7,
                'hierarchical'      => false,
                'query_var'         => true,
				'menu_icon' => 'dashicons-megaphone',
                'supports'  => array (
                    'title', //Text input field to create a post title.
                    'editor',
                    'thumbnail',
                    
                )
            )
        );
register_taxonomy('services_category', 'services', array('hierarchical' => true, 'label' => 'Categories', 'singular_name' => 'Category', "rewrite" => true, "query_var" => true));

    }
}

add_action( 'init', 'services_post_types' ); // register post type

register_taxonomy_for_object_type('category', 'custom-type');

if( ! function_exists( 'adoption_post_types' ) ) {
    function adoption_post_types() {

        register_post_type(
            'adoption',
            array(
                'labels' => array(
                    'name'          => __( 'Adoption', 'adoption' ),
                    'singular_name' => __( 'Adoption', 'adoption' ),
                    'add_new'       => __( 'Add New', 'adoption' ),
                    'add_new_item'  => __( 'Add New Adoption', 'adoption' ),
                    'edit'          => __( 'Edit', 'adoption' ),
                    'edit_item'     => __( 'Edit Adoption', 'adoption' ),
                    'new_item'      => __( 'New Adoption', 'adoption' ),
                    'view'          => __( 'View Adoption', 'adoption' ),
                    'view_item'     => __( 'View Adoption', 'adoption' ),
                    'search_items'  => __( 'Search Adoption', 'adoption' ),
                    'not_found'     => __( 'No Adoption Item found', 'adoption' ),
                    'not_found_in_trash' => __( 'No Adoption item found in Trash', 'adoption' ),
                    'parent'        => __( 'Parent Adoption', 'adoption' ),
                ),
                
                'description'       => __( 'Create a Adoption.', 'adoption' ),
                'public'            => true,
                'show_ui'           => true,
                'show_in_menu'          => true,
                'publicly_queryable'    => true,
				'capability_type' => 'post',
                'exclude_from_search'   => true,
                'menu_position'         => 8,
                'hierarchical'      => false,
                'query_var'         => true,
				'menu_icon' => 'dashicons-image-filter',
                'supports'  => array (
                    'title', //Text input field to create a post title.
                    'editor',
                    'thumbnail',
                    
                )
            )
        );
register_taxonomy('adoption_category', 'adoption', array('hierarchical' => true, 'label' => 'Categories', 'singular_name' => 'Category', "rewrite" => true, "query_var" => true));

    }
}

add_action( 'init', 'adoption_post_types' ); // register post type

register_taxonomy_for_object_type('category', 'custom-type');

if( ! function_exists( 'slider_post_types' ) ) {
    function slider_post_types() {

        register_post_type(
            'slider',
            array(
                'labels' => array(
                    'name'          => __( 'Slider', 'slider' ),
                    'singular_name' => __( 'Slider', 'slider' ),
                    'add_new'       => __( 'Add New', 'slider' ),
                    'add_new_item'  => __( 'Add New Slide', 'slider' ),
                    'edit'          => __( 'Edit', 'slider' ),
                    'edit_item'     => __( 'Edit Slide', 'slider' ),
                    'new_item'      => __( 'New Slide', 'slider' ),
                    'view'          => __( 'View Slide', 'slider' ),
                    'view_item'     => __( 'View Slide', 'slider' ),
                    'search_items'  => __( 'Search Slider', 'slider' ),
                    'not_found'     => __( 'No Slider Item found', 'slider' ),
                    'not_found_in_trash' => __( 'No Slider item found in Trash', 'slider' ),
                    'parent'        => __( 'Parent Slide', 'slider' ),
                ),
                
                'description'       => __( 'Create a Slide.', 'slider' ),
                'public'            => true,
                'show_ui'           => true,
                'show_in_menu'          => true,
                'publicly_queryable'    => true,
				'capability_type' => 'post',
                'exclude_from_search'   => true,
                'menu_position'         => 9,
                'hierarchical'      => false,
                'query_var'         => true,
				'menu_icon' => 'dashicons-images-alt2',
                'supports'  => array (
                    'title', //Text input field to create a post title.
                    'editor',
                    'thumbnail',
                    
                )
            )
        );
register_taxonomy('slider_category', 'slider', array('hierarchical' => true, 'label' => 'Categories', 'singular_name' => 'Category', "rewrite" => true, "query_var" => true));

    }
}

add_action( 'init', 'slider_post_types' ); // register post type

register_taxonomy_for_object_type('category', 'custom-type');


if( ! function_exists( 'verti_team_post_types' ) ) {
    function verti_team_post_types() {

        register_post_type(
            'team',
            array(
                'labels' => array(
                    'name'          => __( 'Team ', 'team' ),
                    'singular_name' => __( 'Team', 'team' ),
                    'add_new'       => __( 'Add New', 'team' ),
                    'add_new_item'  => __( 'Add New Team Member', 'team' ),
                    'edit'          => __( 'Edit', 'team' ),
                    'edit_item'     => __( 'Edit Team Member', 'team' ),
                    'new_item'      => __( 'New Team Member', 'team' ),
                    'view'          => __( 'View Team Member', 'team' ),
                    'view_item'     => __( 'View Team Member', 'team' ),
                    'search_items'  => __( 'Search Team Member', 'team' ),
                    'not_found'     => __( 'No team member found', 'team' ),
                    'not_found_in_trash' => __( 'No team member found in Trash', 'team' ),
                    'parent'        => __( 'Parent Team Member', 'team' ),
                ),
                
                'description'       => __( 'Create a team member.', 'team' ),
                'public'            => true,
				'show_ui'           => true,
				'rewrite' => false,
                'show_in_menu'          => true,
                'publicly_queryable'    => true,
                'exclude_from_search'   => true,
                'menu_position'         => 10,
                'hierarchical'      => true,
                'query_var'         => true,
				'menu_icon' => 'dashicons-id-alt',
                'supports'  => array (
                    'title', //Text input field to create a post title.
                    'editor',
                    'thumbnail',
                    'comments',
					'revisions'
                )
            )
        );
register_taxonomy('team_category', 'team', array('hierarchical' => true, 'label' => 'Team Categories', 'singular_name' => 'Category', "rewrite" => true, "query_var" => true));

    }
	
}

add_action( 'init', 'verti_team_post_types' ); // register post type

register_taxonomy_for_object_type('category', 'custom-type');


/* ==========================================
   Add featured image column to admin panel post list page
========================================== */
add_filter('manage_posts_columns', 'add_img_column');
add_filter('manage_posts_custom_column', 'manage_img_column', 10, 2);

function add_img_column($columns) {
	$columns['img'] = 'Thumbnail';
	return $columns;
}

function manage_img_column($column_name, $post_id) {
	if( $column_name == 'img' ) {
		echo get_the_post_thumbnail( $post_id, array( 80, 60) ); return true; // 80, 60 is for image size.
	}
}

// Change columns order
add_filter('manage_posts_columns', 'column_order');
function column_order($columns) {
  $n_columns = array();
  $move = 'img'; // what to move
  $before = 'title'; // move before this
  foreach($columns as $key => $value) {
    if ($key==$before){
      $n_columns[$move] = $move;
    }
      $n_columns[$key] = $value;
  }
  return $n_columns;
}

// Set columns width
function set_column_width() { ?>
	<style type="text/css">
		/*	Class ".column-img" is for image column */
		.edit-php .fixed .column-img { 
			width: 100px;
		}
	</style>
<?php }
add_action( 'admin_enqueue_scripts', 'set_column_width' );


/**
*
*
*
 * Allow shortcodes in widgets
 * @since v1.0
 */
add_filter('widget_text', 'do_shortcode');

if( !function_exists('symple_fix_shortcodes') ) {
	function symple_fix_shortcodes($content){   
		$array = array (
			'<p>['		=> '[', 
			']</p>'		=> ']', 
			']<br />'	=> ']'
		);
		$content = strtr($content, $array);
		return $content;
	}
	add_filter('the_content', 'symple_fix_shortcodes');
}

// Section Title Shortcode (Visual)
if(! function_exists('wr_vc_section_title_shortcode')){
	function wr_vc_section_title_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'title2'=>'',
			'color'=>'',
			'color2'=>'',
			'font_size'=>'',
			'font_weight'=>'',
			'line_height'=>'',
			'text_align'=>'',
			'text_transform'=>'',			
			'float'=>'',					
			'margin'=>'',					
			'padding'=>'',	
			'margin2'=>'',					
			'padding2'=>'',				
			'df_icon'=>'',				
			'featyretype'=>'',				
			), $atts) );				
		$html='';		
		    $html .='<div class="sec-title '.$class.' '.$df_icon.'">';
			    if($featyretype == "st2"){
			    $html .='<div class="section-heading2 '.$float.'" style="';
					if($margin2 != '') { $html .='margin:'.$margin2.';';} 
					if($padding2 != '') { $html .='padding:'.$padding2.';';}  				
			    $html .='">';
				    if($title != '') {
					$html .='<h3 style="';
						if($margin != '') { $html .='margin:'.$margin.';';} 
						if($padding != '') { $html .='padding:'.$padding.';';}  				
						if($color != '') { $html .='color:'.$color.';';}  				
						if($font_size != '') { $html .='font-size:'.$font_size.';';}  				
						if($font_weight != '') { $html .='font-weight:'.$font_weight.';';}  				
						if($line_height != '') { $html .='line-height:'.$line_height.';';}  				
						if($text_align != '') { $html .='text-align:'.$text_align.';';}  				
						if($text_transform != '') { $html .='text-transform:'.$text_transform.';';} 				
						$html .='">';
						    $html .=''.$title.'';
						$html .='</h3>';
					}
					if($content != '') {	
					$html .='<p>'.$content.'</p>';
					}							
			    $html .='</div>';				
                } else {				
			    $html .='<div class="section-heading '.$float.'" style="';
					if($margin2 != '') { $html .='margin:'.$margin2.';';} 
					if($padding2 != '') { $html .='padding:'.$padding2.';';}  				
			    $html .='">';
				    if($title != '') {
					$html .='<h2 style="';
						if($margin != '') { $html .='margin:'.$margin.';';} 
						if($padding != '') { $html .='padding:'.$padding.';';}  				
						if($color != '') { $html .='color:'.$color.';';}  				
						if($font_size != '') { $html .='font-size:'.$font_size.';';}  				
						if($font_weight != '') { $html .='font-weight:'.$font_weight.';';}  				
						if($line_height != '') { $html .='line-height:'.$line_height.';';}  				
						if($text_align != '') { $html .='text-align:'.$text_align.';';}  				
						if($text_transform != '') { $html .='text-transform:'.$text_transform.';';} 				
						$html .='">';
						    $html .=''.$title.'';
						$html .='</h2>';
					}
					if($content != '') {	
					$html .='<p>'.$content.'</p>';
					}							
			    $html .='</div>';
				}
			$html .='</div>';                
		return $html;
	}
	add_shortcode('wr_vc_section_title', 'wr_vc_section_title_shortcode');
}
// Section Title & Content Shortcode (Visual)
if(! function_exists('wr_vc_section_text_shortcode')){
	function wr_vc_section_text_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'color'=>'',
			'color2'=>'',
			'font_size'=>'',
			'font_weight'=>'',
			'line_height'=>'',
			'text_align'=>'',
			'text_transform'=>'',			
			'float'=>'',					
			'margin'=>'',					
			'padding'=>'',	
			'margin2'=>'',					
			'padding2'=>'',				
			'df_icon'=>'',	
			'button_name'=>'',			
			'button_link_url'=>'',	
			'button_link_target'=>'',				
			), $atts) );				
		$html='';		
		    $html .='<div class="sec-text '.$class.' '.$df_icon.'">';
			    $html .='<div class="section-content '.$float.'" style="';
					if($margin2 != '') { $html .='margin:'.$margin2.';';} 
					if($padding2 != '') { $html .='padding:'.$padding2.';';}  				
			    $html .='">';
				    if($title != '') {
					$html .='<h3 style="';
						if($margin != '') { $html .='margin:'.$margin.';';} 
						if($padding != '') { $html .='padding:'.$padding.';';}  				
						if($color != '') { $html .='color:'.$color.';';}  				
						if($font_size != '') { $html .='font-size:'.$font_size.';';}  				
						if($font_weight != '') { $html .='font-weight:'.$font_weight.';';}  				
						if($line_height != '') { $html .='line-height:'.$line_height.';';}  				
						if($text_align != '') { $html .='text-align:'.$text_align.';';}  				
						if($text_transform != '') { $html .='text-transform:'.$text_transform.';';} 				
						$html .='">';
						    $html .=''.$title.'';
						$html .='</h3>';
					}
					if($content != '') {	
					$html .='<p>'.$content.'</p>';
					}
					if($button_link_url != '' || $button_name != '') {
						$html .='<a class="btn btn-primary" ';
						if($button_link_url != '') { $html .='href="'.$button_link_url.'" ';}					
						if($button_link_target != '') { $html .='target="'.$button_link_target.'"';}
						$html .='>'.$button_name.'</a>'; 
					}					
			    $html .='</div>';
			$html .='</div>';                
		return $html;
	}
	add_shortcode('wr_vc_section_text', 'wr_vc_section_text_shortcode');
}
// Section Image Shortcode (Visual)

if(! function_exists('wr_vc_section_image_shortcode')){
	function wr_vc_section_image_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'width'=>'',
			'height'=>'',
			'margin'=>'',
			'padding'=>'',			
			'position'=>'',			
			'float'=>'',			
			'top'=>'',
			'bottom'=>'',
			'right'=>'',
			'left'=>'',
			'img_url'=>'',
			'link_url'=>'',
			'link_target'=>'',			
			'img_popup'=>'',
			'featyretype'=>'',
			'zindex'=>'',
			'dataaos'=>'',
			'duration'=>'',
			'bordersty'=>'',

			), $atts) );

		$html='';
			
            $woof_back_image ="";
            if($img_url != '' || $img_url != ' ') { 
	            $woof_back_image = wp_get_attachment_image_src( $img_url, 'full');
            }				

			    $html .='<div class="sec-image '.$class.'">';	
                if($featyretype == "st2"){
					if($link_url != '') {	
						$html .='<a href="'.$link_url.'"';
							if($link_target != '') { $html .='target="'.$link_target.'"';}						
						$html .='>';
					}	
				    $html .='<img src="'.$woof_back_image[0].'" ';
					    $html .='style="';
						if($width != '') { $html .='width:'.$width.';';}  				
						if($height != '') { $html .='height:'.$height.';';}  				
						if($float != '') { $html .='float:'.$float.';';}  				
						if($position != '') { $html .='position:'.$position.';';}  				
						if($top != '') { $html .='top:'.$top.';';}  				
						if($bottom != '') { $html .='bottom:'.$bottom.';';}  				
						if($right != '') { $html .='right:'.$right.';';}  				
						if($left != '') { $html .='left:'.$left.';';}  	
                        if($zindex != '') { $html .='z-index:'.$zindex.';';}  						
						if($margin != '') { $html .='margin:'.$margin.';';} 
						if($padding != '') { $html .='padding:'.$padding.';';}
						$html .='"';
					$html .=' alt="" data-aos="'.$dataaos.'"  data-aos-duration="'.$duration.'"  class="img-fluid '.$bordersty.'"/>';
					if($link_url != '') {
						$html .='</a>';
					}						
				} elseif ($featyretype == "st3"){	
				
				} else {
					if($link_url != '') {	
						$html .='<a href="'.$link_url.'"';
							if($link_target != '') { $html .='target="'.$link_target.'"';}						
						$html .='>';
					}	
				    $html .='<img src="'.$woof_back_image[0].'" ';
					    $html .='style="';
						if($width != '') { $html .='width:'.$width.';';}  				
						if($height != '') { $html .='height:'.$height.';';}  				
						if($float != '') { $html .='float:'.$float.';';}  				
						if($position != '') { $html .='position:'.$position.';';}  				
						if($top != '') { $html .='top:'.$top.';';}  				
						if($bottom != '') { $html .='bottom:'.$bottom.';';}  				
						if($right != '') { $html .='right:'.$right.';';}  				
						if($left != '') { $html .='left:'.$left.';';}  				
						if($zindex != '') { $html .='z-index:'.$zindex.';';}  				
						if($margin != '') { $html .='margin:'.$margin.';';} 
						if($padding != '') { $html .='padding:'.$padding.';';}
						$html .='"';
					$html .=' alt="" class="img-responsive"/>';
					if($link_url != '') {
						$html .='</a>';
					}	
				}	
				$html .='</div>';			
                
		return $html;
	}
	add_shortcode('wr_vc_section_image', 'wr_vc_section_image_shortcode');
}
// Section Video Shortcode (Visual)
if(! function_exists('wr_vc_section_video_shortcode')){
	function wr_vc_section_video_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'link_url'=>'',
			'margin2'=>'',					
			'padding2'=>'',				
			), $atts) );
		$html='';		
		
			$html .='<div class="sec-video '.$class.'" style="';
				if($margin2 != '') { $html .='margin:'.$margin2.';';} 
				if($padding2 != '') { $html .='padding:'.$padding2.';';}  				
			$html .='">';			
				$html .='<div class="embed-responsive embed-responsive-4by3">';
					if($link_url != '') {	
						$html .='<iframe class="embed-responsive-item" src="'.$link_url.'" allowfullscreen></iframe>';		
					}
				$html .='</div>'; 	                             
			$html .='</div>';                
		return $html;
	}
	add_shortcode('wr_vc_section_video', 'wr_vc_section_video_shortcode');
}
// Triangle Color Section Shortcode (Visual)
if(! function_exists('wr_vc_triangle_shortcode')){
	function wr_vc_triangle_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
											
			), $atts) );
		
        $html='';
		    $html .='<div class="sec-triangle '.$class.'">';  
                $html .='<svg id="bigTriangleColor" class="d-none d-sm-block" xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100" viewBox="0 0 100 102" preserveAspectRatio="none">
         <path d="M0 0 L50 100 L100 0 Z" />
      </svg>';  		
            $html .='</div>';  		
			
		return $html;
	}
	add_shortcode('wr_vc_triangle', 'wr_vc_triangle_shortcode');
}
// Slider Shortcode (Visual)

if(! function_exists('wr_vc_slider_shortcode')){
	function wr_vc_slider_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'showpost'=>'',	
			'categoryname'=>'',						
			'postoffset'=>'',							
			'featyretype'=>'',
			'typeview'=>'',				
			), $atts) );
			
		$html='';
		
		$html .='<div class="sec-slider '.$class.'">';		
		    $html .='<div id="slider" style="width:1200px;height:800px;padding:0;margin:0 auto;margin-bottom: 0px;">';		
					
	            global $post;
	            $paged=(get_query_var('paged'))?get_query_var('paged'):1;
	            $loop = new WP_Query( array( 'post_type' => 'slider','slider_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) ); while ( $loop->have_posts() ) : $loop->the_post();	
				    
					$html .='<div class="ls-slide" data-ls="duration:4000; transition2d:7; kenburnszoom:out; kenburnsrotate:-5; kenburnsscale:1.2;">';	
				        if (has_post_thumbnail( $post->ID ) ):	
					    $woof_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), '' );
							$html .= '<img src="';
							    $html .= $woof_image[0];
							$html .= '" alt="" class="ls-bg"/>';
                        endif;	
                        $html .='<div class="ls-l header-wrapper" data-ls="offsetyin:150; durationin:700; delayin:200; easingin:easeOutQuint; rotatexin:20; scalexin:1.4; offsetyout:600; durationout:400; parallaxlevel:0;">';
						
						if (( get_post_meta($post->ID,'rnr_intro_slider_style',true))=='style2'):
						    $html .= '<div class="header-text dog-elements">';
							    if (( get_post_meta($post->ID,'rnr_slider_title',true))=='no'){
								} else {	
								$html .= '<h1>';
									if (( get_post_meta($post->ID,'rnr_intro-slider-title',true))):
										$html .= get_post_meta($post->ID,'rnr_intro-slider-title',true);
									else:	
										$html .= get_the_title();
									endif;	
								$html .= '</h1>';
								}				
								if (( get_post_meta($post->ID,'rnr_slider_content',true))=='no'){
								} else {
                                $html .= '<div class="d-none d-sm-block">';
                                    $html .= '<p class="header-p">';
									    $html .=get_the_content();
									$html .= '</p>';
									if (( get_post_meta($post->ID,'rnr_slider-intro-button1',true))):
									$html .= '<a href="';
										$html .= get_post_meta($post->ID,'rnr_slider-intro-button-url1',true);
									$html .= '" class="btn btn-primary">';
										$html .= get_post_meta($post->ID,'rnr_slider-intro-button1',true);
									$html .= '</a>';
									endif;									
								$html .='</div>';		
								}
                            $html .='</div>';							
						elseif (( get_post_meta($post->ID,'rnr_intro_slider_style',true))=='style3'):
						    $html .= '<div class="header-text cat-elements">';
							    if (( get_post_meta($post->ID,'rnr_slider_title',true))=='no'){
								} else {	
								$html .= '<h1>';
									if (( get_post_meta($post->ID,'rnr_intro-slider-title',true))):
										$html .= get_post_meta($post->ID,'rnr_intro-slider-title',true);
									else:	
										$html .= get_the_title();
									endif;	
								$html .= '</h1>';
								}				
								if (( get_post_meta($post->ID,'rnr_slider_content',true))=='no'){
								} else {
                                $html .= '<div class="d-none d-sm-block">';
                                    $html .= '<p class="header-p">';
									    $html .=get_the_content();
									$html .= '</p>';
									if (( get_post_meta($post->ID,'rnr_slider-intro-button1',true))):
									$html .= '<a href="';
										$html .= get_post_meta($post->ID,'rnr_slider-intro-button-url1',true);
									$html .= '" class="btn btn-primary">';
										$html .= get_post_meta($post->ID,'rnr_slider-intro-button1',true);
									$html .= '</a>';
									endif;									
								$html .='</div>';		
								}
                            $html .='</div>';	
						else:	
						    $html .= '<div class="header-text no-elements">';
							    if (( get_post_meta($post->ID,'rnr_slider_title',true))=='no'){
								} else {	
								$html .= '<h1>';
									if (( get_post_meta($post->ID,'rnr_intro-slider-title',true))):
										$html .= get_post_meta($post->ID,'rnr_intro-slider-title',true);
									else:	
										$html .= get_the_title();
									endif;	
								$html .= '</h1>';
								}				
								if (( get_post_meta($post->ID,'rnr_slider_content',true))=='no'){
								} else {
                                $html .= '<div class="d-none d-sm-block">';
                                    $html .= '<p class="header-p">';
									    $html .=get_the_content();
									$html .= '</p>';
									if (( get_post_meta($post->ID,'rnr_slider-intro-button1',true))):
									$html .= '<a href="';
										$html .= get_post_meta($post->ID,'rnr_slider-intro-button-url1',true);
									$html .= '" class="btn btn-primary">';
										$html .= get_post_meta($post->ID,'rnr_slider-intro-button1',true);
									$html .= '</a>';
									endif;									
								$html .='</div>';		
								}
                            $html .='</div>';							
						endif;	
                        $html .='</div>';	
                    $html .='</div>';					
				endwhile; wp_reset_postdata();	
			$html .='</div>';						
		$html .='</div>';						
		return $html;
	}
	add_shortcode('wr_vc_slider', 'wr_vc_slider_shortcode');
}
// Protfolio Section Shortcode (Visual)
 if(! function_exists('wr_vc_portfolio_body_shortcode')){
	function wr_vc_portfolio_body_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'postcount'=>'',
			'categoryname'=>'',
			'postoffset'=>'',
			'featyretype'=>'',
			'styletype'=>'',
			
			), $atts) );
		$html='';
		
		$woof_options = get_option('woof');
		
        $html .= '<div class="port-vc '.$class.'">';		
			
		    if($featyretype == "st1"){
		    } else {
		
			if(!get_post_meta(get_the_ID(), 'portfolio_category', true)):
			$portfolio_category = get_terms('portfolio_category');
			if($portfolio_category):
			$html .= '<ul class="nav nav-pills cat center-nav">';			
			    		
				if(!empty($woof_options['prf-project-filter-all'])):
				$html .= '<li class="nav-item">';	
					$html .= '<a class="nav-link active" href="#" data-toggle="tab" data-filter="*">';
					$html .= ($woof_options['prf-project-filter-all']);
					$html .= '</a>';	
				$html .= '</li>';	
				else :
				$html .= '<li class="nav-item">';
					$html .= '<a class="nav-link active" href="#" data-toggle="tab" data-filter="*">All</a>';	
				$html .= '</li>';
				endif;		
			    
				foreach($portfolio_category as $portfolio_cat):
				$html .= '<li class="nav-item">';
					$html .= '<a class="nav-link" href="#" data-toggle="tab" data-filter=".';
					$html .= $portfolio_cat->slug;
					$html .= '">';
					$html .= $portfolio_cat->name;
					$html .= '</a>';
				$html .= '</li>';
				endforeach;

			$html .= '</ul>';
			endif; 
			endif;
			
		    }			
        					
			$html .= '<div id="gallery-isotope" class="mt-5">';
			
			global $post;
			
			$paged=(get_query_var('paged'))?get_query_var('paged'):1;
			$loop = new WP_Query( array( 'post_type' => 'portfolio', 'portfolio_category'=> $categoryname, 'posts_per_page'=> $postcount, 'orderby' => 'post_date', 'showposts' => $postcount, 'offset' => $postoffset ) );
			
			while ( $loop->have_posts() ) : $loop->the_post();
			
			$portfolio_category = wp_get_post_terms($post->ID,'portfolio_category');
			$firenze_class = ""; 
			$firenze_categories = ""; 
			foreach ($portfolio_category as $firenze_item) {
				$firenze_class.=esc_attr($firenze_item->slug . ' ');
				$firenze_categories.='<span class="cat-divider">';
				$firenze_categories.=esc_attr($firenze_item->name . '  ');
				$firenze_categories.='</span>';
			}	

				$html .= '<div class="col-lg-3 col-sm-6 col-md-6 ';
				$html .= $firenze_class;	
				$html .= ' ">';
			        $html .= '<div class="isotope-item">';
						$html .= '<div class="gallery-thumb">';

							if (has_post_thumbnail( $post->ID ) ):		
							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_portfolio_slider' );
							$html .='<img class="img-fluid" src="';
							$html .= $image[0];
							$html .= '" alt="" />';	
		
							$html .= '<a href="';
							$html .= $image[0];
							$html .= '" title="';								
							$html .=get_the_title();
							$html .= '">';
							$html .= '<span class="overlay-mask"></span></a>';
						    endif;		
			            $html .= '</div>';				
			        $html .= '</div>';				
			    $html .= '</div>';					
			
			endwhile;
			wp_reset_query();	
			
            $html .= '</div>';				

		$html .= '</div>';	
		
		return $html;
	}
	add_shortcode('wr_vc_portfolio', 'wr_vc_portfolio_body_shortcode');
}

// Protfolio Slider Section Shortcode (Visual)
 if(! function_exists('wr_vc_portfolio_slider_body_shortcode')){
	function wr_vc_portfolio_slider_body_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'postcount'=>'',
			'categoryname'=>'',
			'postoffset'=>'',
			
			), $atts) );
		$html='';		
		
        $html .= '<div class="port-vc-slider '.$class.'">';			
        					
			$html .= '<div id="owl-gallery" class="owl-gallery owl-carousel owl-theme top-centered-nav fade-effect mt-5">';
			
			global $post;			
			$paged=(get_query_var('paged'))?get_query_var('paged'):1;
			$loop = new WP_Query( array( 'post_type' => 'portfolio', 'portfolio_category'=> $categoryname, 'posts_per_page'=> $postcount, 'orderby' => 'post_date', 'showposts' => $postcount, 'offset' => $postoffset ) );			
			while ( $loop->have_posts() ) : $loop->the_post();	

				$html .= '<div class="col-md-12 gallery-img rotate-img">';
				
					if (has_post_thumbnail( $post->ID ) ):		
						$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_portfolio_slider' );
						$html .= '<a href="';
						$html .= $image[0];
						$html .= '" title="';								
						$html .=get_the_title();
						$html .= '">';														
							$html .='<img class="border-double img-fluid border-irregular1" src="';
							$html .= $image[0];
							$html .= '" alt="" />';	
						$html .= '</a>';
					endif;					
				$html .= '</div>';								
			
			endwhile;
			wp_reset_query();	
			
            $html .= '</div>';				

		$html .= '</div>';	
		
		return $html;
	}
	add_shortcode('wr_vc_portfolio_slider', 'wr_vc_portfolio_slider_body_shortcode');
}

// Services Shortcode (Visual)

if(! function_exists('wr_vc_services_shortcode')){
	function wr_vc_services_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'showpost'=>'',	
			'categoryname'=>'',										
			'postoffset'=>'',
			'featyretype'=>'',
			
			), $atts) );
		
		$html='';
		$woof_options = get_option('woof');
		global $post;
		$html .='<div class="sec-services '.$class.'">';
		    if($featyretype == "st2"){
		    $html .='<div class="res-margin">';
		        $html .='<div id="owl-services2" class="top-centered-nav owl-carousel owl-theme">';

					$paged=(get_query_var('paged'))?get_query_var('paged'):1;
					$loop = new WP_Query( array( 'post_type' => 'services','services_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) ); while ( $loop->have_posts() ) : $loop->the_post();
					$html .= '<div class="col-md-12 service-hover-box">';
						$html .='<a href="';
						$html .= get_the_permalink();
						$html .='">';			
							if (has_post_thumbnail( $post->ID ) ):		
							$woof_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_services_slider' );	
							$html .='<img class="img-fluid border-irregular1" src="';
							$html .= $woof_image[0];
							$html .= '" alt="" />';	
							endif;
							$html .='<div class="service-hover-caption">';
								$html .='<h4>';
								$html .=get_the_title();
								$html .='</h4>';
								$html .='<p>';	
								$html .= substr(strip_tags($post->post_content), 0, 60);
								$html .='</p>';	
							$html .='</div>';	
						$html .='</a>';													
					$html .='</div>';		
					endwhile;
					wp_reset_postdata();

		        $html .='</div>';
		    $html .='</div>';				
		    } else {
		    $html .='<div class="bg-light-custom block-padding border-irregular1">';
		        $html .='<div class="owl-services container owl-carousel owl-theme">';

					$paged=(get_query_var('paged'))?get_query_var('paged'):1;
					$loop = new WP_Query( array( 'post_type' => 'services','services_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) ); while ( $loop->have_posts() ) : $loop->the_post();
					$html .= '<div class="col-md-12">';
						$html .= '<div class="serviceBox">';
							if (get_post_meta($post->ID,'rnr_services_icon',true)!=''):;
							$html .='<div class="service-icon">';
								$html .='<i class="';
								$html .= get_post_meta($post->ID,'rnr_services_icon',true);
								$html .='"></i>';
							$html .='</div>';
							endif;	
							$html .='<div class="service-content">';
								$html .='<h6>';
								$html .=get_the_title();
								$html .='</h6>';
								$html .='<p>';	
								$html .= substr(strip_tags($post->post_content), 0, 82);
								$html .='</p>';	
								if(!empty($woof_options['blog-read-more'])):;
								$html .='<a href="';
								$html .= get_the_permalink();
								$html .='" class="btn btn-primary">';			
								$html .= ($woof_options['blog-read-more']);
								$html .='</a>';	
								else :
								$html .='<a href="';
								$html .= get_the_permalink();
								$html .='" class="btn btn-primary">';			
								$html .='read more';	
								$html .='</a>';	
								endif;										
							$html .='</div>';									
						$html .='</div>';									
					$html .='</div>';		
					endwhile;
					wp_reset_postdata();

		        $html .='</div>';
		    $html .='</div>';
			}
		$html .='</div>';
				
		return $html;
	}
	add_shortcode('wr_vc_services', 'wr_vc_services_shortcode');
}

// Adoption Shortcode (Visual)

if(! function_exists('wr_vc_adoption_shortcode')){
	function wr_vc_adoption_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'showpost'=>'',	
			'categoryname'=>'',										
			'postoffset'=>'',
			'button_name'=>'',			
			'button_link_url'=>'',	
			'button_link_target'=>'',
			
			), $atts) );
		
		$html='';
		$woof_options = get_option('woof');
		global $post;
		$html .='<div class="sec-adoption '.$class.'">';
		$html .='<div class="row mt-5">';

			$paged=(get_query_var('paged'))?get_query_var('paged'):1;
			$loop = new WP_Query( array( 'post_type' => 'adoption','adoption_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) ); while ( $loop->have_posts() ) : $loop->the_post();
			$html .= '<div class="adopt-card col-md-6 col-xl-3 res-margin">';
				$html .= '<div class="card bg-light-custom">';
					$html .= '<div class="thumbnail text-center">';
					
						if (has_post_thumbnail( $post->ID ) ):
						$woof_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_adopt' );
							$html .= '<img class="border-irregular1 img-fluid" src="';
								 $html .= $woof_image[0];
							$html .= '" alt=""/>';
						endif;						
										
						$html .='<div class="caption-adoption">';
							$html .='<h6 class="adoption-header">';
							$html .=get_the_title();
							$html .='</h6>';
							
							$html .='<ul class="list-unstyled">';
							    
								$woof_pet_info = rwmb_meta( 'rnr_woof_pet_info' );
								if ( ! empty( $woof_pet_info ) ) {
								foreach ( $woof_pet_info as $woof_pet_infos ) {
								$woof_pet_data1 = isset( $woof_pet_infos['rnr_data1'] ) ? $woof_pet_infos['rnr_data1'] : '';
								$woof_pet_data2 = isset( $woof_pet_infos['rnr_data2'] ) ? $woof_pet_infos['rnr_data2'] : '';
								if ( !empty( $woof_pet_data1 ) ) {
								if ( !empty( $woof_pet_data2 ) ) {
								$html .='<li><strong>';
								$html .= ''.$woof_pet_data1.'';
								$html .='</strong> ';
								$html .= ''.$woof_pet_data2.'';
								$html .='</li>';
								}
								}
								} }
							    
							$html .='</ul>';
								
							$html .='<div class="text-center">';
								if(!empty($woof_options['adopt-read-more'])):;
								$html .='<a href="';
								$html .= get_the_permalink();
								$html .='" class="btn btn-primary">';			
								$html .= ($woof_options['adopt-read-more']);
								$html .='</a>';	
								else :
								$html .='<a href="';
								$html .= get_the_permalink();
								$html .='" class="btn btn-primary">';			
								$html .='More Info';	
								$html .='</a>';	
								endif;										
							$html .='</div>';								
						$html .='</div>';									
					$html .='</div>';		
			    $html .='</div>';		
			$html .='</div>';		
			endwhile;
			wp_reset_postdata();

		$html .='</div>';

			if($button_link_url != '' || $button_name != '') {
			$html .='<div class="text-center mt-5">';	
				$html .='<a class="btn btn-secondary btn-lg" ';
				if($button_link_url != '') { $html .='href="'.$button_link_url.'" ';}					
				if($button_link_target != '') { $html .='target="'.$button_link_target.'"';}
				$html .='>'.$button_name.'</a>'; 
			$html .='</div>';	
			}			

		$html .='</div>';
				
		return $html;
	}
	add_shortcode('wr_vc_adoption', 'wr_vc_adoption_shortcode');
}

// Team Member Shortcode (Visual)
if(! function_exists('wr_vc_team_shortcode')){
	function wr_vc_team_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'postoffset'=>'',
			'showpost'=>'',	
			'categoryname'=>'',
			'featyretype'=>'',
			'styletype'=>'',
			'link_target'=>'',
			), $atts) );
		$html='';		
		$html .='<div class="sec-team '.$class.'">';	
		
		if($featyretype == "st2"){
			
			$html .='<div class="owl-team2 owl-carousel owl-theme mt-5">';	
			global $post;
			$paged=(get_query_var('paged'))?get_query_var('paged'):1;
			$loop = new WP_Query( array( 'post_type' => 'team','team_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) );
			while ( $loop->have_posts() ) : $loop->the_post();		
				$html .='<figure class="col-lg-12 team-style2">';							
					if (has_post_thumbnail( $post->ID ) ):
					$woof_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_team_member' );
						$html .= '<img class="img-fluid" src="';
							 $html .= $woof_image[0];
						$html .= '" alt=""/>';
					endif;												

					if($styletype == "st1"){  
					} else {
					$html .='<figcaption>';		
					    $html .='<div class="icons">';		
							if (get_post_meta($post->ID,'rnr_facebook_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_facebook_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-facebook-f"></i></a>';
							endif;			
							if (get_post_meta($post->ID,'rnr_twitter_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_twitter_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-twitter"></i></a>';
							endif;
							if (get_post_meta($post->ID,'rnr_googleplus_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_googleplus_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-google-plus"></i></a>';
							endif;	
							if (get_post_meta($post->ID,'rnr_linkedin_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_linkedin_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-linkedin"></i></a>';
							endif;		
							if (get_post_meta($post->ID,'rnr_instagram_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_instagram_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-instagram"></i></a>';
							endif;
							if (get_post_meta($post->ID,'rnr_pinterest_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_pinterest_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-pinterest-p"></i></a>';
							endif;		
							if (get_post_meta($post->ID,'rnr_whatsapp_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_whatsapp_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-whatsapp"></i></a>';
							endif;
							if (get_post_meta($post->ID,'rnr_skype_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_skype_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-skype"></i></a>';
							endif;
							if (get_post_meta($post->ID,'rnr_dribbble_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_dribbble_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-dribbble"></i></a>';
							endif;	
							if (get_post_meta($post->ID,'rnr_youtube_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_youtube_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-youtube"></i></a>';
							endif;	
							if (get_post_meta($post->ID,'rnr_vimeo_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_vimeo_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-vimeo"></i></a>';
							endif;		
							if (get_post_meta($post->ID,'rnr_git_hub_link',true)!=''):;
							$html .= '<a href="';		
							$html .= get_post_meta($post->ID,'rnr_git_hub_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fab fa-github"></i></a>';
							endif;
							if (get_post_meta($post->ID,'rnr_email_link',true)!=''):;
							$html .= '<a href="mailto:';		
							$html .= get_post_meta($post->ID,'rnr_email_link',true);
							$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
							$html .='><i class="fa fa-envelope"></i></a>';
							endif;	
					    $html .='</div>';
					$html .='</figcaption>';
					}
					$html .='<div class="name">';			
						$html .='<h4>';
						$html .=get_the_title();
						$html .='</h4>';								
						if (get_post_meta($post->ID,'rnr_team_author_prof',true)!=''):;
						$html .='<h6>';
						$html .= get_post_meta($post->ID,'rnr_team_author_prof',true);
						$html .='</h6>';
						endif;							
					$html .='</div>';						
				$html .='</figure>';
			endwhile;
			wp_reset_query();	
			$html .='</div>';		
		    		
		} elseif ($featyretype == "st3"){	
			
			$html .='<div class="owl-team3 owl-carousel owl-theme mt-5">';	
			global $post;
			$paged=(get_query_var('paged'))?get_query_var('paged'):1;
			$loop = new WP_Query( array( 'post_type' => 'team','team_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) );
			while ( $loop->have_posts() ) : $loop->the_post();		
				$html .='<figure class="col-lg-12 team-style3">';							
					if (has_post_thumbnail( $post->ID ) ):
					$woof_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_team_member' );
						$html .= '<img class="img-fluid" src="';
							 $html .= $woof_image[0];
						$html .= '" alt=""/>';
					endif;												

					if($styletype == "st1"){  
					} else {		
					$html .='<div class="icons">';		
						if (get_post_meta($post->ID,'rnr_facebook_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_facebook_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-facebook-f"></i></a>';
						endif;			
						if (get_post_meta($post->ID,'rnr_twitter_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_twitter_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-twitter"></i></a>';
						endif;
						if (get_post_meta($post->ID,'rnr_googleplus_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_googleplus_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-google-plus"></i></a>';
						endif;	
						if (get_post_meta($post->ID,'rnr_linkedin_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_linkedin_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-linkedin"></i></a>';
						endif;		
						if (get_post_meta($post->ID,'rnr_instagram_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_instagram_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-instagram"></i></a>';
						endif;
						if (get_post_meta($post->ID,'rnr_pinterest_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_pinterest_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-pinterest-p"></i></a>';
						endif;		
						if (get_post_meta($post->ID,'rnr_whatsapp_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_whatsapp_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-whatsapp"></i></a>';
						endif;
						if (get_post_meta($post->ID,'rnr_skype_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_skype_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-skype"></i></a>';
						endif;
						if (get_post_meta($post->ID,'rnr_dribbble_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_dribbble_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-dribbble"></i></a>';
						endif;	
						if (get_post_meta($post->ID,'rnr_youtube_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_youtube_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-youtube"></i></a>';
						endif;	
						if (get_post_meta($post->ID,'rnr_vimeo_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_vimeo_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-vimeo"></i></a>';
						endif;		
						if (get_post_meta($post->ID,'rnr_git_hub_link',true)!=''):;
						$html .= '<a href="';		
						$html .= get_post_meta($post->ID,'rnr_git_hub_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-github"></i></a>';
						endif;
						if (get_post_meta($post->ID,'rnr_email_link',true)!=''):;
						$html .= '<a href="mailto:';		
						$html .= get_post_meta($post->ID,'rnr_email_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fa fa-envelope"></i></a>';
						endif;	
					$html .='</div>';
					}
					$html .='<figcaption>';			
						$html .='<h4>';
						$html .=get_the_title();
						$html .='</h4>';								
						if (get_post_meta($post->ID,'rnr_team_author_prof',true)!=''):;
						$html .='<h6>';
						$html .= get_post_meta($post->ID,'rnr_team_author_prof',true);
						$html .='</h6>';
						endif;	
						$html .='<p>';	
						$html .= substr(strip_tags($post->post_content), 0, 250);
						$html .='</p>';						
					$html .='</figcaption>';						
				$html .='</figure>';
			endwhile;
			wp_reset_query();	
			$html .='</div>';	
			
		} else {
			
			$html .='<div class="owl-team1 owl-carousel owl-theme mt-5">';	
			global $post;
			$paged=(get_query_var('paged'))?get_query_var('paged'):1;
			$loop = new WP_Query( array( 'post_type' => 'team','team_category'=> $categoryname,'posts_per_page'=> $showpost, 'offset' => $postoffset) );
			while ( $loop->have_posts() ) : $loop->the_post();		
				$html .='<div class="team-style1 col-md-12 ">';							
					if (has_post_thumbnail( $post->ID ) ):
					$woof_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woof_team_member' );
					$html .='<div class="team-image">';
						$html .= '<img src="';
							 $html .= $woof_image[0];
						$html .= '" alt=""/>';
					$html .='</div>';	
					endif;												
					$html .='<div class="team-info">';			
						$html .='<h4>';
						$html .=get_the_title();
						$html .='</h4>';								
						if (get_post_meta($post->ID,'rnr_team_author_prof',true)!=''):;
						$html .='<h6>';
						$html .= get_post_meta($post->ID,'rnr_team_author_prof',true);
						$html .='</h6>';
						endif;	
						$html .='<p>';	
						$html .= substr(strip_tags($post->post_content), 0, 150);
						$html .='</p>';							
					$html .='</div>';	
					if($styletype == "st1"){  
					} else {
					$html .='<ul class="social">';		
						if (get_post_meta($post->ID,'rnr_facebook_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_facebook_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-facebook-f"></i></a></li>';
						endif;			
						if (get_post_meta($post->ID,'rnr_twitter_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_twitter_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-twitter"></i></a></li>';
						endif;
						if (get_post_meta($post->ID,'rnr_googleplus_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_googleplus_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-google-plus"></i></a></li>';
						endif;	
						if (get_post_meta($post->ID,'rnr_linkedin_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_linkedin_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-linkedin"></i></a></li>';
						endif;		
						if (get_post_meta($post->ID,'rnr_instagram_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_instagram_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-instagram"></i></a></li>';
						endif;
						if (get_post_meta($post->ID,'rnr_pinterest_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_pinterest_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-pinterest-p"></i></a></li>';
						endif;		
						if (get_post_meta($post->ID,'rnr_whatsapp_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_whatsapp_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-whatsapp"></i></a></li>';
						endif;
						if (get_post_meta($post->ID,'rnr_skype_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_skype_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-skype"></i></a></li>';
						endif;
						if (get_post_meta($post->ID,'rnr_dribbble_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_dribbble_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-dribbble"></i></a></li>';
						endif;	
						if (get_post_meta($post->ID,'rnr_youtube_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_youtube_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-youtube"></i></a></li>';
						endif;	
						if (get_post_meta($post->ID,'rnr_vimeo_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_vimeo_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-vimeo"></i></a></li>';
						endif;		
						if (get_post_meta($post->ID,'rnr_git_hub_link',true)!=''):;
						$html .= '<li><a href="';		
						$html .= get_post_meta($post->ID,'rnr_git_hub_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fab fa-github"></i></a></li>';
						endif;
						if (get_post_meta($post->ID,'rnr_email_link',true)!=''):;
						$html .= '<li><a href="mailto:';		
						$html .= get_post_meta($post->ID,'rnr_email_link',true);
						$html .= '" '; if($link_target != '') { $html .='target="'.$link_target.'"';}
						$html .='><i class="fa fa-envelope"></i></a></li>';
						endif;	
					$html .='</ul>';
					}	
				$html .='</div>';
			endwhile;
			wp_reset_query();	
			$html .='</div>';
		}	

		$html .='</div>';				
		return $html;
	}
	add_shortcode('wr_vc_team', 'wr_vc_team_shortcode');
}

// Counter Section Shortcode (Visual)

if(! function_exists('wr_vc_counter_shortcode')){
	function wr_vc_counter_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'counter_name1'=>'',			
			'counter_num1'=>'',		
			'icon_name'=>'',		
		
			), $atts) );

				
		$html='';
		    
			$html .='<div class="sec-counter '.$class.'">';			
                    
				if($counter_num1 != '') {                    
					$html .='<div class="counter">';
						if($icon_name != '') {  
						$html .='<i class="counter-icon '.$icon_name.'"></i>';
						}
						$html .='<div class="counter-value" data-count="'.$counter_num1.'">0</div>';
						$html .='<h3 class="title">'.$counter_name1.'</h3>';
					$html .='</div>';
				} 
					

            $html .='</div>';
                
		return $html;
	}
	add_shortcode('wr_vc_counter', 'wr_vc_counter_shortcode');
}

// Socail Section Shortcode (Visual)

if(! function_exists('wr_vc_social_shortcode')){
	function wr_vc_social_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'icon_name'=>'',			
			'link_target'=>'',			
			'sc_facebook'=>'',					
			'sc_twitter'=>'',					
			'sc_instagram'=>'',					
			'sc_google'=>'',															
			'sc_pinterest'=>'',															
			'sc_linkedin'=>'',				
			'sc_youtube'=>'',	
			'sc_vimeo'=>'',	
			'sc_skype'=>'',	
			'sc_behance'=>'',	
			'sc_soundcloud'=>'',		
			'sc_dribbble'=>'',	
			'sc_email'=>'',	
			
			), $atts) );

				
		$html='';
		    
		$html .='<div class="sec-contact-social '.$class.'">';			
			$html .='<div class="contact-icon">'; 
				if($icon_name != '') {  
					$html .='<i class="fa '.$icon_name.' top-icon"></i>';
				}
				$html .='<div class="contact-icon-info">';  	
					if($title != '') { 
					$html .='<h5>'.$title.'</h5>'; 
					}
					$html .='<ul class="social-media">';
						
						if($sc_facebook != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_facebook.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-facebook-square"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_twitter != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_twitter.'" ';					
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-twitter"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_instagram != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_instagram.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-instagram"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_google != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_google.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-google-plus"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_pinterest != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_pinterest.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-pinterest-p"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_linkedin != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_linkedin.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-linkedin"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_youtube != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_youtube.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-youtube"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_vimeo != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_vimeo.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-vimeo"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_skype != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_skype.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-skype"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_behance != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_behance.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-behance"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_soundcloud != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_soundcloud.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-soundcloud"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_dribbble != '') {                    
						$html .='<li>';
							$html .='<a href="'.$sc_dribbble.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-dribbble"></i>';
							$html .='</a>';
						$html .='</li>';
						} if($sc_email != '') {                    
						$html .='<li>';
							$html .='<a href="mailto:'.$sc_email.'" ';				
								if($link_target != '') { $html .='target="'.$link_target.'"';}						
							$html .='>';
								$html .='<i class="fab fa-envelope-o"></i>';
							$html .='</a>';
						$html .='</li>';
						} 
						
					$html .='</ul>';
				$html .='</div>';  	
			$html .='</div>';  					
        $html .='</div>';
                
		return $html;
	}
	add_shortcode('wr_vc_social', 'wr_vc_social_shortcode');
}

// Newsletter (Visual)
if(! function_exists('wr_vc_newsletter_shortcode')){
	function wr_vc_newsletter_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'contactfromid'=>'',
			), $atts) );

		$html='';			
            $html .='<div class="sec-newsletter '.$class.'">';
				$html .='<div class="bg-primary text-light card text-center" >';
					if($title != '') {
					$html .='<h4>'.$title.'</h4>';
					}
					if($content != '') {	            		
						$html .=''.$content.'';
					}						
					$html .='<div id="mc_embed_signup">'; 
					$html .='<div class="input-group">'; 
					    $html .=''.do_shortcode('[mc4wp_form id="'.$contactfromid.'"]').''; 
					$html .='</div>'; 							    
					$html .='</div>'; 							    
			    $html .='</div>'; 			
			$html .='</div>'; 			

		return $html;	
	}
	add_shortcode('wr_vc_newsletter', 'wr_vc_newsletter_shortcode');
}

// Contact Info (Visual)
if(! function_exists('wr_vc_contact_info_shortcode')){
	function wr_vc_contact_info_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'icon_name'=>'',		
			'address'=>'',	
			'featyretype'=>'',
			'con_phone1'=>'',
			'con_phone2'=>'',
			'con_phone3'=>'',
			'con_mail1'=>'',
			'con_mail2'=>'',
			'con_mail3'=>'',			
			),  $atts) );
		$html='';
			if($featyretype == "st2"){
			$html .='<div class="sec-contact-info2 '.$class.'">'; 	
			    $html .='<div class="offset-lg-1 h-50 card bg-secondary res-margin">'; 	
			        $html .='<div class="contact-info text-light ">'; 	
			            $html .='<div class="text-light">'; 
							if($title != '') { 
							$html .='<h5>'.$title.'</h5>'; 
							} if($content != '') {
							$html .='<p>'.$content.'</p>';	
							}						
				            $html .='<ul class="list-unstyled mt-5 list-contact">'; 
								if($con_mail1 != '' || $con_mail2 != '' || $con_mail3 != '') {
									$html .='<li class="h7"><i class="fa fa-envelope margin-icon"></i><a href="mailto:'.$con_mail1.'">'.$con_mail1.'</a></li>';
									if($con_mail2 != '') {	
									$html .='<li class="h7"><i class="fa fa-envelope margin-icon"></i><a href="mailto:'.$con_mail2.'">'.$con_mail2.'</a></li>';
									} if($con_mail3 != '') {				
									$html .='<li class="h7"><i class="fa fa-envelope margin-icon"></i><a href="mailto:'.$con_mail3.'">'.$con_mail3.'</a></li>';
									} 			
								}
								if($con_phone1 != '' || $con_phone2 != '' || $con_phone3 != '') {
									$html .='<li class="h7"><i class="fa fa-phone margin-icon"></i>'.$con_phone1.'</li>';
									if($con_phone2 != '') {			
									$html .='<li class="h7"><i class="fa fa-phone margin-icon"></i>'.$con_phone2.'</li>'; 
									} if($con_phone3 != '') {	
									$html .='<li class="h7"><i class="fa fa-phone margin-icon"></i>'.$con_phone3.'</li>';
									}
								}												
								if($address != '') {	            		
									$html .='<li class="h7" ><i class="fa fa-map-marker margin-icon"></i>'.$address.'</li>';
								}		
				            $html .='</ul>';
			            $html .='</div>';	
			        $html .='</div>';	
			    $html .='</div>';	
			$html .='</div>';	
			} else {		
			$html .='<div class="sec-contact-info '.$class.'">'; 
				$html .='<div class="contact-icon">'; 
					if($icon_name != '') {  
						$html .='<i class="fa '.$icon_name.' top-icon"></i>';
					}
					$html .='<div class="contact-icon-info">';  	
						if($title != '') { 
						$html .='<h5>'.$title.'</h5>'; 
						} if($content != '') {
						$html .='<p class="h7">'.$content.'</p>';	
						}
					$html .='</div>';  	
				$html .='</div>';  	 	
			$html .='</div>';  
		    }		
        return $html;						
	}
	add_shortcode('wr_vc_contact_info', 'wr_vc_contact_info_shortcode');
}

// Contact Form (Visual)
if(! function_exists('wr_vc_contact_shortcode')){
	function wr_vc_contact_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'title'=>'',
			'contactfromid'=>'',
			'featyretype'=>'',
			), $atts) );

		$html='';	
			$html .='<div class="sec-form contact-form '.$class.'">'; 
			    if($featyretype == "st2"){
			    $html .='<div class="contact-info card bg-light-custom">'; 
					if($title != '') {  
					$html .='<h4>'.$title.'</h4>';
					}
			        $html .='<div id="contact_form">'; 
						$html .='<div class="form-group">'; 
							$html .=''.do_shortcode('[contact-form-7 id="'.$contactfromid.'" title="Contact form"]').''; 
						$html .='</div>'; 			
					$html .='</div>'; 	
				$html .='</div>'; 	
                } else {
			    $html .='<div class="contact-info">'; 
					if($title != '') {  
					$html .='<h4>'.$title.'</h4>';
					}
			        $html .='<div id="contact_form">'; 
						$html .='<div class="form-group">'; 
							$html .=''.do_shortcode('[contact-form-7 id="'.$contactfromid.'" title="Contact form"]').''; 
						$html .='</div>'; 			
					$html .='</div>'; 	
				$html .='</div>'; 						
				}	
            $html .='</div>'; 				
		return $html;	
	}
	add_shortcode('wr_vc_contact_form', 'wr_vc_contact_shortcode');
}

// google map
if(! function_exists('wr_vc_map_shortcode')){
	function wr_vc_map_shortcode($atts, $content = null){
		extract(shortcode_atts( array(
			'class'=>'',
			'id'=>'',
			'image'=>'',
			'title'=>'',
			'subtitle'=>'',
			'location'=>'',
			'address'=>'',		
			'featyretype'=>'',		
			
			), $atts) );
		if(is_numeric($image)) {
            $woof_image = wp_get_attachment_url( $image );
        }else {
            $woof_image = $image;
        }
		
		$html='';
		$dot="'";
			if($featyretype == "st2"){
			$html .= '<div id="map-canvas" class="mt-3 border-irregular1"  data-location="[ '.$location.' ]" data-adress="'.$address.'" data-icon="'.$woof_image.'"></div>';
			} else {
			$html .= '<div id="map-canvas" class="aos-init aos-animate" data-location="[ '.$location.' ]" data-adress="'.$address.'" data-icon="'.$woof_image.'"></div>';
			}				
		return $html;
	}
	add_shortcode('wr_vc_map', 'wr_vc_map_shortcode');
}

?>