<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/docs/define-meta-boxes
 */

/********************* META BOX DEFINITIONS ***********************/

/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
$prefix = 'rnr_';

global $meta_boxes;

$meta_boxes = array();

global $smof_data;


/* ----------------------------------------------------- */
// Revolution Slider
/* ----------------------------------------------------- */

$revolutionslider = array();
$revolutionslider[0] = 'No Slider';

if(class_exists('RevSlider')){
    $slider = new RevSlider();
	$arrSliders = $slider->getArrSliders();
	foreach($arrSliders as $revSlider) { 
		$revolutionslider[$revSlider->getAlias()] = $revSlider->getTitle();
	}
}

/* Page Section Background Settings */

$grid_array = array('2 Columns','3 Columns','4 Columns');

$pagebg_type_array = array(
	'image' => 'Image',
	'gradient' => 'Gradient',
	'color' => 'Color'
);

/* ----------------------------------------------------- */
/* Overall Page Settings
/* ----------------------------------------------------- */
$meta_boxes[] = array(
	'id' => 'overallpageseting',
	'title' => 'Overall Page Settings',
	'pages' => array( 'page' ),
	'context' => 'normal',	

	'fields' => array(		

		array(
				'id' => $prefix . 'page-header-show',
				'name' => esc_html__( 'Header Section', 'sportsox' ),
				'type' => 'select_advanced',
				'desc' => esc_html__( 'Enable / Disable Header Section', 'sportsox' ),
				'placeholder' => esc_html__( 'Select an Option', 'sportsox' ),
				'options' => array(
					'yes' => 'Enable',
					'no' => 'Disable',
				),
				'std' => 'yes',
			),		
		array(
				'id' => $prefix . 'page-title-show',
				'name' => esc_html__( 'Page Title', 'sportsox' ),
				'type' => 'select_advanced',
				'desc' => esc_html__( 'Enable / Disable Title Section', 'sportsox' ),
				'placeholder' => esc_html__( 'Select an Option', 'sportsox' ),
				'options' => array(
					'yes' => 'Enable',
					'no' => 'Disable',
				),
				'std' => 'yes',
			),
		array(
			'name'     => __( 'Page Title Text', 'woof' ),
			'id'   => $prefix . 'page-title',
			'desc'		=> 'Insert page title text here.',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),			
		
		
	)
);

/* ----------------------------------------------------- */
// Default Page Settings
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'defaultpageseting',
	'title' => 'Default Page Settings',
	'pages' => array( 'page' ),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(	
		
		// SELECT BOX
		array(
			'name'     => __( 'Default Page Layout', 'dogmawp' ),
			'id'   => $prefix . 'wr-pagetype',
			'desc'  => __( 'Select "Default Page Template" At Page Attributes Template Option.', 'dogmawp' ),
			'type'     => 'image_select',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'st1' => __( get_template_directory_uri().'/includes/metaboxes/img/wr-page-default.png', 'dogmawp' ),
				'st2' => __( get_template_directory_uri().'/includes/metaboxes/img/wr-page-full.png', 'dogmawp' ),
				'st3' => __( get_template_directory_uri().'/includes/metaboxes/img/wr-page-left.png', 'dogmawp' ),
				'st4' => __( get_template_directory_uri().'/includes/metaboxes/img/wr-page-right.png', 'dogmawp' ),
				
			),
			'desc'		=> '',
			// Select multiple values, optional. Default is false.
			'multiple'    => false,
			'std'         => 'st1',
			'placeholder' => esc_attr__( 'Select an Option', 'dogmawp' ),
		),	
	
	)
);

/* ----------------------------------------------------- */
// Blog Page Settings
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'blogpageseting',
	'title' => 'Blog Page Settings',
	'pages' => array( 'page' ),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(		

		// SELECT BOX
		array(
			'name'     => __( 'Blog Page Layout', 'dogmawp' ),
			'id'   => $prefix . 'wr-blogtype',
			'desc'  => __( 'Select "Blog Page Template" At Page Attributes Template Option.', 'dogmawp' ),
			'type'     => 'image_select',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'st1' => __( get_template_directory_uri().'/includes/metaboxes/img/wr-page-right.png', 'dogmawp' ),
				'st2' => __( get_template_directory_uri().'/includes/metaboxes/img/wr-page-left.png', 'dogmawp' ),
				
			),
			'desc'		=> '',
			// Select multiple values, optional. Default is false.
			'multiple'    => false,
			'std'         => 'st1',
			'placeholder' => esc_attr__( 'Select an Option', 'dogmawp' ),
		),	

			array(
				'name'       => __( 'Number Of Post Show', 'blps' ),
				'id'         => $prefix . 'blog-post-show',
				'type'       => 'slider',
				// Text labels displayed before and after value
				'prefix'     => __( '', 'blps' ),
				'suffix'     => __( ' Posts', 'blps' ),
				'js_options' => array(
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				),
			),	

			array(
			'name'		=> 'Exclude Category',
			'id'		=> $prefix . 'blog-post-cat',
			'desc'		=> 'Enter category name ex: web design, web development (Optional)',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
				
	
	)
);

/* ----------------------------------------------------- */
// Adoption Page Settings
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'adoptionpageseting',
	'title' => 'Adoption Page Settings',
	'pages' => array( 'page' ),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(	
		array(
			'name'     => __( 'Adoption Page Section', 'woof' ),
			'id'   => $prefix . 'adoption-on-off',
			'type'     => 'radio',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'yes' => __( 'Enable', 'woof' ),
				'no' => __( 'Disable', 'woof' ),
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'no',

		),	
		array(
			'name'		=> 'Adoption Section Title',
			'id'		=> $prefix . 'adoption-title-text',
			'desc'		=> 'Insert section title text here. Ex: Find a new furry Friend',
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Adoption Section Content',
			'id'		=> $prefix . 'adoption-content-text',
			'desc'		=> 'Insert section content text here.',
			'type'		=> 'textarea',
			'std'		=> ''
		),		
		array(
			'name'       => __( 'Number Of Post Show', 'blps' ),
			'id'         => $prefix . 'adoption-post-show',
			'type'       => 'slider',
			// Text labels displayed before and after value
			'prefix'     => __( '', 'blps' ),
			'suffix'     => __( ' Posts', 'blps' ),
			'js_options' => array(
				'min'  => 1,
				'max'  => 100,
				'step' => 1,
			),
		),	
		array(
			'name'		=> 'Exclude Category',
			'id'		=> $prefix . 'adoption-post-cat',
			'desc'		=> 'Enter category name ex: web design, web development (Optional)',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
				
	
	)
);

// Blog Post Metaboxes
/* ----------------------------------------------------- */


$meta_boxes[] = array(
	'id' => 'rnr-blogmeta-video',
	'title' => 'Post Format Video Option',
	'pages' => array( 'post'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(

		array(
			'name'		=> 'Vimeo/ Youtube Video Link:',
			'id'		=> $prefix . 'bl-video',
			'desc'		=> 'Set Vimeo / YouTube Video Embed Link',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),

		
	)
);


/* ----------------------------------------------------- */
/* Slider Post Type Metaboxes
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'slider_options',
	'title' => 'Slider Options',
	'pages' => array( 'slider' ),
	'context' => 'normal',	
	'fields' => array(		
		array(
			'name'     => __( 'Slide Title', 'woof' ),
			'id'   => $prefix . 'slider_title',
			'type'     => 'select_advanced',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'yes' => __( 'Enable', 'woof' ),
				'no' => __( 'Disable', 'woof' ),
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'yes',

		),	
		array(
			'name'		=> 'Slide Title Text',
			'id'		=> $prefix . 'intro-slider-title',
			'desc'		=> 'Insert Slide Title Text.',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),	
		array(
			'name'     => __( 'Slide Content', 'woof' ),
			'id'   => $prefix . 'slider_content',
			'type'     => 'select_advanced',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'yes' => __( 'Enable', 'woof' ),
				'no' => __( 'Disable', 'woof' ),
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'yes',

		),		
		array(
			'name'		=> 'Button Name',
			'id'		=> $prefix . 'slider-intro-button1',
			'clone'		=> false,
			'type'		=> 'text',
			'desc'		=> 'Insert Button Name Here.',
		),			
		array(
			'name'		=> 'Button Link URL',
			'id'		=> $prefix . 'slider-intro-button-url1',
			'clone'		=> false,
			'type'		=> 'text',
			'desc'		=> 'Insert Button URL Here.',
		),
		array(
			'name'     => __( 'Slider Icon', 'sldtlst' ),
			'id'   => $prefix . 'intro_slider_style',
			'type'     => 'select_advanced',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'style1' => __( 'No Icon', 'sldtlst' ),
				'style2' => __( 'Dog Icon', 'sldtlst' ),
				'style3' => __( 'Cat Icon', 'sldtlst' ),
				
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'style1',

		),
		
	)
);

/* ----------------------------------------------------- */
/* Services Post Type Metaboxes
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'services_options',
	'title' => 'Services Options',
	'pages' => array( 'services' ),
	'context' => 'normal',	
	'fields' => array(
		array(
			'name'		=> 'Services Name',
			'id'		=> $prefix . 'services_icon',
			'clone'		=> false,
			'type'		=> 'text',
			'desc'		=> 'Insert Services Icon Here. Ex: flaticon-pet-shelter',
		),		
		array(
			'name'     => __( 'Services Highlight Box', 'woof' ),
			'id'   => $prefix . 'services-highlight-show',
			'type'     => 'select_advanced',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'yes' => __( 'Enable', 'woof' ),
				'no' => __( 'Disable', 'woof' ),
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'no',

		),	
		array(
			'name'		=> 'Services Highlight Title',
			'id'		=> $prefix . 'services-highlight-title',
			'desc'		=> 'Insert Services Highlight Here. Ex: Service Highlights ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),				
		array(
			'name'		=> 'Services List Item',
			'id'		=> $prefix . 'woof_services_info',
			'desc'		=> 'Insert Services Services Highlight List Item Here.',
			'clone'		=> true,
			'type'		=> 'textarea',
			'std'		=> ''
		),

		array(
			'name'		=> 'Details Header Image',
			'id'		=> $prefix . 'services-deatils-header-img',
			'clone'		=> false,
			'type'		=> 'image_advanced',
			'desc'		=> 'Upload Details Page Header Image Here.',
		),		
		array(
			'name'		=> 'Details Page Header Title',
			'id'		=> $prefix . 'services-deatils-header-title',
			'desc'		=> 'Insert Services Details Page Header Title. Ex: Pet Training',
			'type'		=> 'text',
			'std'		=> ''
		),			
	)
);

/* ----------------------------------------------------- */
/* Adoption Post Type Metaboxes
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'adoption_options',
	'title' => 'Adoption Options',
	'pages' => array( 'adoption' ),
	'context' => 'normal',	
	'fields' => array(
		array(
			'name'     => __( 'Adoption Info Content', 'woof' ),
			'id'   => $prefix . 'adopt-project-info-on-off',
			'type'     => 'select_advanced',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'yes' => __( 'Enable', 'woof' ),
				'no' => __( 'Disable', 'woof' ),
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'yes',

		),		
		array(
			'name'		=> 'Adoption Slider Images',
			'id'		=> $prefix . 'adoption-details-img',
			'clone'		=> false,
			'type'		=> 'image_advanced',
			'desc'		=> 'Upload Adoption Deatails Page Slider Images Image',
		),	
		array(
			'name'		=> 'Pet Name Text',
			'id'		=> $prefix . 'pet-title',
			'desc'		=> 'Insert Pet Name Text Here. Ex: Pet Name: ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),			
		array(
			'name'		=> 'Pet Info Text Content',
			'id'		=> $prefix . 'pet-info-text',
			'desc'		=> 'Insert pet info text content here.',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),	
		array(
			'name'		=> 'Pet Info Button Name',
			'id'		=> $prefix . 'pet-info-button',
			'desc'		=> 'Insert pet info button text here. Ex: Adopt now! ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),	
		array(
			'name'		=> 'Pet Info Button URL',
			'id'		=> $prefix . 'pet-info-button-url',
			'desc'		=> 'Insert pet info button url link here. ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
            array(
				'id'		=> $prefix . 'woof_pet_info',
				'name'        => 'Pet Info List',
				'type'        => 'group',
				'clone'       => true,
				'sort_clone'  => true,
				'collapsible' => true,
				'group_title' => 'Pet Info List item', // ID of the subfield
				'save_state' => true,
				'fields' => array(
					array(
						'name' => 'List Item Title',
						'id'		=> $prefix . 'data1',
						'type' => 'text',
						'desc'		=> 'Insert list item title text here. Ex: Gender:',
					),
					array(
						'name' => 'List Item Content',
						'id'		=> $prefix . 'data2',
						'type' => 'text',
						'desc'		=> 'Insert list item content text here. Ex: Female',
					),
					
				),
			),	
			
		array(
			'name'     => __( 'Adoption Alert Box', 'woof' ),
			'id'   => $prefix . 'pet-alert-show',
			'type'     => 'select_advanced',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'yes' => __( 'Enable', 'woof' ),
				'no' => __( 'Disable', 'woof' ),
			),
			// Select multiple values, optional. Default is false.
			'std'         => 'no',

		),	
		array(
			'name'		=> 'Adoption Alert Title',
			'id'		=> $prefix . 'pet-alert-title',
			'desc'		=> 'Insert Adoption Alert Title Here. Ex: Adoption Rules ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),			
		array(
			'name'		=> 'Adoption Alert Text Content',
			'id'		=> $prefix . 'pet-alert-text',
			'desc'		=> 'Insert adoption alert text content here.',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),		

	)
);
			
			
/* ----------------------------------------------------- */
/* Team Post Type Metaboxes
/* ----------------------------------------------------- */


$meta_boxes[] = array(
	'id' => 'team_options',
	'title' => 'Team Member Options',
	'pages' => array( 'team' ),
	'context' => 'normal',	
	'fields' => array(
	
		array(
			'name'		=> 'Member Designation',
			'id'		=> $prefix . 'team_author_prof',
			'desc'		=> 'Insert Team Member Designation Here. Ex: Co Founder & Ceo',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
	)
);
$meta_boxes[] = array(
	'id' => 'team_social',
	'title' => 'Team Member Social',
	'pages' => array( 'team' ),
	'context' => 'normal',	

	'fields' => array(
	
		array(
			'name'		=> 'Facebook',
			'id'		=> $prefix . 'facebook_link',
			'desc'		=> 'Write Your Facebook Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Twitter',
			'id'		=> $prefix . 'twitter_link',
			'desc'		=> 'Write Your Twitter Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Google+',
			'id'		=> $prefix . 'googleplus_link',
			'desc'		=> 'Write Your Google+ Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Instagram',
			'id'		=> $prefix . 'instagram_link',
			'desc'		=> 'Write Your Instagram Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'LinkedIn',
			'id'		=> $prefix . 'linkedin_link',
			'desc'		=> 'Write Your LinkedIn Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
		array(
			'name'		=> 'Pinterest',
			'id'		=> $prefix . 'pinterest_link',
			'desc'		=> 'Write Your Pinterest Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
		array(
			'name'		=> 'Whatsapp',
			'id'		=> $prefix . 'whatsapp_link',
			'desc'		=> 'Write Your Whatsapp Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
		array(
			'name'		=> 'Skype',
			'id'		=> $prefix . 'skype_link',
			'desc'		=> 'Write Your Skype Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Dribbble',
			'id'		=> $prefix . 'dribbble_link',
			'desc'		=> 'Write Your Dribbble Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
		array(
			'name'		=> 'Youtube',
			'id'		=> $prefix . 'youtube_link',
			'desc'		=> 'Write Your Youtube Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Vimeo',
			'id'		=> $prefix . 'vimeo_link',
			'desc'		=> 'Write Your Vimeo Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
		array(
			'name'		=> 'Github',
			'id'		=> $prefix . 'git_hub_link',
			'desc'		=> 'Write Your Github Link.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),		
		array(
			'name'		=> 'E-mail',
			'id'		=> $prefix . 'email_link',
			'desc'		=> 'Write Your E-mail Address.',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),	
		
	)
);

/********************* META BOX REGISTERING ***********************/

/**
 * Register meta boxes
 *
 * @return void
 */
function designer_register_meta_boxes()
{
	global $meta_boxes;

	// Make sure there's no errors when the plugin is deactivated or during upgrade
	if ( class_exists( 'RW_Meta_Box' ) )
	{
		foreach ( $meta_boxes as $meta_box )
		{
			new RW_Meta_Box( $meta_box );
		}
	}
}

// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'designer_register_meta_boxes' );