<?php

class woof_working_hours extends WP_Widget {
    var $settings = array( 'title', 'day1', 'day2', 'day3', 'day4', 'day5', 'day6', 'day7');

    function __construct() {
        $widget_ops = array('description' => 'Use this widget to add time schedule as a widget.' );
        parent::__construct(false, __('Woof - Time Schedule Widget', 'woof'),$widget_ops);
}


function widget($args, $instance) {
        $settings = $this->woof_get_settings();
        extract( $args, EXTR_SKIP );
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : ( ' Contacts' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
        $instance = wp_parse_args( $instance, $settings );
        extract( $instance, EXTR_SKIP );

      
        echo $before_widget;
		 if ( $title ) echo $before_title . $title . $after_title; 
		
		echo '<ul>';
		
		if ( $day1 != '' ) {
		echo '<li>'.esc_html($day1).'</li>';
		}
		if ( $day2 != '' ) {
		echo '<li>'.esc_html($day2).'</li>';
		}
		if ( $day3 != '' ) {
		echo '<li>'.esc_html($day3).'</li>';
		}
		if ( $day4 != '' ) {
		echo '<li>'.esc_html($day4).'</li>';
		}
		if ( $day5 != '' ) {
		echo '<li>'.esc_html($day5).'</li>';
		}
		if ( $day6 != '' ) {
		echo '<li>'.esc_html($day6).'</li>';
		}
		if ( $day7 != '' ) {
		echo '<li>'.esc_html($day7).'</li>';
		}
		
		echo '</ul>';
		
		
       echo $after_widget;      
    }
	
	


function update( $new_instance, $old_instance ) {
        foreach ( array( 'title', 'day1', 'day2', 'day3', 'day4', 'day5', 'day6', 'day7' ) as $setting )
            $new_instance[$setting] = strip_tags( $new_instance[$setting] );
        // Users without unfiltered_html cannot update this arbitrary HTML field
        if ( !current_user_can( 'unfiltered_html' ) )
            $new_instance['address'] = $old_instance['address'];
        return $new_instance;
    }


    function woof_get_settings() {
        // Set the default to a blank string
        $settings = array_fill_keys( $this->settings, '' );
        // Now set the more specific defaults
        return $settings;
    }

    function form($instance) {
        $instance = wp_parse_args( $instance, $this->woof_get_settings() );
        extract( $instance, EXTR_SKIP );
?>

    <p>
        <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />
    </p>
	
	
	
	<p>
        <label for="<?php echo $this->get_field_id('day1'); ?>"><?php esc_html_e('Day 1:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day1'); ?>" value="<?php echo esc_attr( $day1 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day1'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('day2'); ?>"><?php esc_html_e('Day 2:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day2'); ?>" value="<?php echo esc_attr( $day2 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day2'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('day3'); ?>"><?php esc_html_e('Day 3:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day3'); ?>" value="<?php echo esc_attr( $day3 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day3'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('day4'); ?>"><?php esc_html_e('Day 4:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day4'); ?>" value="<?php echo esc_attr( $day4 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day4'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('day5'); ?>"><?php esc_html_e('Day 5:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day5'); ?>" value="<?php echo esc_attr( $day5 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day5'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('day6'); ?>"><?php esc_html_e('Day 6:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day6'); ?>" value="<?php echo esc_attr( $day6 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day6'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('day3'); ?>"><?php esc_html_e('Day 7:','woof'); ?><br> e.x: Open 9am - 10pm</label>
        <input type="text" name="<?php echo $this->get_field_name('day7'); ?>" value="<?php echo esc_attr( $day7 ); ?>" class="widefat" id="<?php echo $this->get_field_id('day7'); ?>" />
    </p>
	
	
	
    

    <?php 

    }
}

register_widget('woof_working_hours');