<?php

class woof_contact_widget extends WP_Widget {
    var $settings = array( 'title', 'phone', 'phone2', 'email', 'address',  'buttonurl');

    function __construct() {
        $widget_ops = array('description' => 'Use this widget to add any type of Contact Details as a widget.' );
        parent::__construct(false, __('Woof - Contact Widget', 'woof'),$widget_ops);
}


function widget($args, $instance) {
        $settings = $this->woof_get_settings();
        extract( $args, EXTR_SKIP );
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : ( ' Contacts' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
        $instance = wp_parse_args( $instance, $settings );
        extract( $instance, EXTR_SKIP );

      
        echo $before_widget;
		 if ( $title ) echo $before_title . $title . $after_title; 
		
		echo '<ul>';
		
		if ( $phone != '' ) {
		echo '<li><a href="tel:'.esc_attr($phone).'">'.esc_html($phone).'</a></li>';
		}
		if ( $phone2 != '' ) {
		echo '<li><a href="tel:'.esc_attr($phone2).'">'.esc_html($phone2).'</a></li>';
		}
		
		if ( $email != '' ) {
		echo '<li><a href="mailto:'.esc_attr($email).'">'.esc_html($email).'</a></li>';
		}
		if ( $address != '' ) {
		if ( $buttonurl != '' ) {
		echo '<li><a href="'.esc_url($buttonurl).'" target="_blank" >'.esc_html($address).'</a></li>';
		}
		else { 
		echo '<li>'.esc_html($address).'</li>';
		}
		}
		echo '</ul>';
		
		
       echo $after_widget;      
    }
	
	


function update( $new_instance, $old_instance ) {
        foreach ( array( 'title', 'phone', 'phone2', 'email', 'email_title', 'address', 'buttonurl' ) as $setting )
            $new_instance[$setting] = strip_tags( $new_instance[$setting] );
        // Users without unfiltered_html cannot update this arbitrary HTML field
        if ( !current_user_can( 'unfiltered_html' ) )
            $new_instance['address'] = $old_instance['address'];
        return $new_instance;
    }


    function woof_get_settings() {
        // Set the default to a blank string
        $settings = array_fill_keys( $this->settings, '' );
        // Now set the more specific defaults
        return $settings;
    }

    function form($instance) {
        $instance = wp_parse_args( $instance, $this->woof_get_settings() );
        extract( $instance, EXTR_SKIP );
?>

    <p>
        <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />
    </p>
	
	
	
	<p>
        <label for="<?php echo $this->get_field_id('phone'); ?>"><?php esc_html_e('Phone Number 1:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('phone'); ?>" value="<?php echo esc_attr( $phone ); ?>" class="widefat" id="<?php echo $this->get_field_id('phone'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('phone2'); ?>"><?php esc_html_e('Phone Number 2:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('phone2'); ?>" value="<?php echo esc_attr( $phone2 ); ?>" class="widefat" id="<?php echo $this->get_field_id('phone2'); ?>" />
    </p>
    
	
   
    <p>
        <label for="<?php echo $this->get_field_id('email'); ?>"><?php esc_html_e('E-mail:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('email'); ?>" value="<?php echo esc_attr( $email ); ?>" class="widefat" id="<?php echo $this->get_field_id('email'); ?>" />
    </p>
	
	
	
	<p>
        <label for="<?php echo $this->get_field_id('address'); ?>"><?php esc_html_e('Address:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('address'); ?>" value="<?php echo esc_attr( $address ); ?>" class="widefat" id="<?php echo $this->get_field_id('address'); ?>" />
    </p>
	
	
	<p>
        <label for="<?php echo $this->get_field_id('buttonurl'); ?>"><?php esc_html_e('Address URL:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('buttonurl'); ?>" value="<?php echo esc_attr( $buttonurl ); ?>" class="widefat" id="<?php echo $this->get_field_id('buttonurl'); ?>" />
    </p>
	
	
    

    <?php 

    }
}

register_widget('woof_contact_widget');