<?php

class woof_about_widget extends WP_Widget {
    var $settings = array( 'title','woof_title', 'woof_logo', 'woof_text', 'woof_icon');

    function __construct() {
        $widget_ops = array('description' => 'Disaply Image & Short Summry.' );
        parent::__construct(false, __('Woof - About Widget', 'woof'),$widget_ops);
}


function widget($args, $instance) {
        $settings = $this->woof_get_settings();
        extract( $args, EXTR_SKIP );
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : ( '' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
        $instance = wp_parse_args( $instance, $settings );
        extract( $instance, EXTR_SKIP );

      
        echo $before_widget;
		 if ( $title != '' ) { echo $before_title . $title . $after_title; 
		 }
		
		echo '<div class="about-widget">';
		echo '<a class="navbar-brand" href="'.esc_url(home_url( '/' )).'">';
		if ( $woof_logo != '' ) {
			echo '<img src="'.esc_url($woof_logo).'" alt="'.get_bloginfo('name').'">';
		}
		else {
			if ( $woof_title != '' ) {
			if ( $woof_icon != '' ) {
			echo '<i class="'.esc_attr($woof_icon).'"></i>';
			}
			echo '<span class="footer-logo">'.esc_attr($woof_title).'</span>';
			}
		}
		echo '</a>';
		if ( $woof_text != '' ) {
		echo '<p class="mt-3">';
		echo esc_html($woof_text);
		echo '</p>';
		}
		
		echo '</div>';
		
		
       echo $after_widget;      
    }
	
	


function update( $new_instance, $old_instance ) {
        foreach ( array( 'title', 'woof_logo', 'woof_text', 'woof_title', 'woof_icon' ) as $setting )
            $new_instance[$setting] = strip_tags( $new_instance[$setting] );
        // Users without unfiltered_html cannot update this arbitrary HTML field
        if ( !current_user_can( 'unfiltered_html' ) )
            $new_instance['woof_text'] = $old_instance['woof_text'];
        return $new_instance;
    }


    function woof_get_settings() {
        // Set the default to a blank string
        $settings = array_fill_keys( $this->settings, '' );
        // Now set the more specific defaults
        return $settings;
    }

    function form($instance) {
        $instance = wp_parse_args( $instance, $this->woof_get_settings() );
        extract( $instance, EXTR_SKIP );
?>

    <p>
        <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('woof_icon'); ?>"><?php esc_html_e('Icon Class:','woof'); ?><br> <a href="http://webredox.net/demo/wp/woof/icon" target="_blank">Flaticon</a> Ex: flaticon-dog-20 <br><a href="fontawesome" target="_blank">Fontawesome Icon</a> Ex: fab fa-android</p> </label>
        <input type="text" name="<?php echo $this->get_field_name('woof_icon'); ?>" value="<?php echo esc_attr( $woof_icon ); ?>" class="widefat" id="<?php echo $this->get_field_id('woof_icon'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('woof_title'); ?>"><?php esc_html_e('Text Logo:','woof'); ?><br> <?php esc_html_e('e.x: Woof!','woof'); ?> </label>
        <input type="text" name="<?php echo $this->get_field_name('woof_title'); ?>" value="<?php echo esc_attr( $woof_title ); ?>" class="widefat" id="<?php echo $this->get_field_id('woof_title'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('woof_logo'); ?>"><?php esc_html_e('Image URL:','woof'); ?><br><?php esc_html_e('e.x: http://webredox.net/demo/wp/woof/wp-content/uploads/2018/12/logo.png','woof'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('woof_logo'); ?>" value="<?php echo esc_attr( $woof_logo ); ?>" class="widefat" id="<?php echo $this->get_field_id('woof_logo'); ?>" />
    </p>
	
	
	<p>
        <label for="<?php echo $this->get_field_id('woof_text'); ?>"><?php esc_html_e('Content:','woof'); ?></label>
        <textarea name="<?php echo $this->get_field_name('woof_text'); ?>" value="<?php echo esc_attr( $woof_text ); ?>" class="widefat" id="<?php echo $this->get_field_id('woof_text'); ?>" ><?php echo esc_textarea( $instance['woof_text'] ); ?></textarea/>
    </p>
    
	
	
	
    

    <?php 

    }
}

register_widget('woof_about_widget');